
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1160.C - Message 1160 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1160 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1160.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:54   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:01:00   COLEJ
//   Multiple Changes...
//   
//      Rev 1.2   Feb 12 1997 16:05:28   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 10:07:42   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:58   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <share.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);
   
extern char  frqtblfile[32]; 
extern short   StoreFrqTbl;

extern FILE  *stream4;

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1160 message from the ZMsgBuf.
//
void Dec1160(tMSGBUF *ZMsgBuf, tMSG1160 *Msg)
{                                            
   tFLOAT FreqOffset, ErrorEstimate, RateEstimate, Error;
   tSHORT Week, i;

   for(i=0; i<256; i++){ 
   GetBits   (&FrqTblData[i].Week , ZMsgBuf,14+i, 0, 8);   //
   GetBits   (&FrqTblData[i].Error, ZMsgBuf,14+i, 8, 8);   //
   } 
   
   // store frequency table in a file
   if(StoreFrqTbl && (stream4 = _fsopen(frqtblfile, "wt", SH_DENYWR)) != NULL){
   clear_message_line();
   ShowText("STORING FREQUENCY STANDARD TABLE DATA IN FILE ... ", CMDR, CMDC);
   StoreFrqTbl = 0;

   FreqOffset    = (tFLOAT)(Msg->TableFreqOffset     * 0.15);
   ErrorEstimate = (tFLOAT)(Msg->OffsetErrorEstimate * 0.002);
   RateEstimate  = (tFLOAT)(Msg->AgingRateEstimate   * 0.0002);
   
   fprintf(stream4,"FREQUENCY STANDARD TABLE DATA\n");
   fprintf(stream4,"FILENAME      : %s\n\n"  , frqtblfile);
   fprintf(stream4,"SEQ NUMBER    : %-8d\n"   , Msg->SequenceNumber);
   fprintf(stream4,"FREQ OFFSET   : %-8.2f\n" , FreqOffset);
   fprintf(stream4,"OFFSET VALID  : %-8d\n"   , Msg->TableFreqOffsetValid);
   fprintf(stream4,"OFFSET ERROR  : %-8.3f\n" , ErrorEstimate);
   fprintf(stream4,"AGING RATE    : %-8.4f\n" , RateEstimate);
   fprintf(stream4,"LAST UPD WEEK : %-8u\n\n" , Msg->LastRateUpdateWeek);


   fprintf(stream4," ENTRY   WEEK     PPM\n");
   for(i=0; i<256; i++){
      Week  = FrqTblData[i].Week * 4;
      if((FrqTblData[i].Error & 0xFF) > 127){
        Error = (tFLOAT)(((tFLOAT)(FrqTblData[i].Error & 0xFF) - 256) * 0.15);
      }
      else{
        Error = (tFLOAT)((tFLOAT)(FrqTblData[i].Error & 0xFF)  * 0.15);
      }
      fprintf(stream4,"%6d %6u %7.2f\n", i, Week, Error);
   }
   
   fclose(stream4);
   ShowText("DONE", CMDR, CMDC+50);
   }
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1160 message in the ZMsgBuf. 
//
void Bld1160(tMSGBUF *ZMsgBuf, tMSG1160 *Msg)
{
   tSHORT i;

   // ack flags assumed preset

   PutShort  (0x81FF                         , ZMsgBuf, 1);     // message preamble
   PutShort  (1160                           , ZMsgBuf, 2);     // message number
   PutShort  (264                            , ZMsgBuf, 3);     // message length 
   PutShort  (ANREQ                          , ZMsgBuf, 4);     // message ack/nack request
 //PutShort  (CheckSum(ZMsgBuf[0], 4)        , ZMsgBuf, 5);     // header check sum
                                                   
   PutShort  (Msg->SequenceNumber            , ZMsgBuf, 8);     // ND   
   PutShort  (Msg->TableFreqOffset           , ZMsgBuf, 9);     // .15 * ppm   
   PutShort  (Msg->TableFreqOffsetValid      , ZMsgBuf,10);     // 1=valid   
   PutShort  (Msg->OffsetErrorEstimate       , ZMsgBuf,11);     // .002 * ppm  
   PutShort  (Msg->AgingRateEstimate         , ZMsgBuf,12);     // .0002 * ppm/yr   
   PutShort  (Msg->LastRateUpdateWeek        , ZMsgBuf,13);     // week 
                                             
   for(i=0; i<256; i++){                     
   PutUShort (Msg->FreqStdTable[i]           , ZMsgBuf,14+i);   //
   PutBits   (FrqTblData[i].Week  , ZMsgBuf,14+i, 0, 8);   //
   PutBits   (FrqTblData[i].Error , ZMsgBuf,14+i, 8, 8);   //
   }                                         
   //PutShort  (CheckSum(ZMsgBuf, 6,264)     , ZMsgBuf,270);     // data check sum 
}                                            

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1160 message from the ZMsgBuf.
//
void Show1160(tMSG1160 *Msg)
{
   // tbd
}                                                 
                                      
                                           
